<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AuthController extends Controller
{
    protected $redirectTo = 'dashboard';

    public function __construct(){
        $this->middleware("guest")->except("logout");
    }

    public function index(){
        return view("login");
    }

    public function authenticate(Request $request){
        $credentials = $request->only(["email", "password"]);
        
        if(Auth::attempt($credentials)){
            return redirect()->route($this->redirectTo);
        }else{
            return redirect()
                    ->route("login")
                    ->with("warning", "Usuário e/ou senha inválidos.");
        }
    }

    public function logout(){
        Auth::logout();
        return redirect()
        ->route("login")
        ->with("warning", "Usuário .");
    }
}
