<?php

namespace App\Http\Controllers;

use App\Http\Services\GoogleSheetsIntegrationService;
use App\Models\CelebrationPriceItem;
use App\Models\VpdPriceItem;
use Google\Client;
use Google\Service\Sheets;
use Google\Service\Sheets\ValueRange;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
class GoogleSheetsIntegrationController extends Controller
{    
    public function __construct(protected GoogleSheetsIntegrationService $googleSheetsIntegrationService) {

    }

    public function index(Request $request){
        
        $collection = collect($this->googleSheetsIntegrationService->index($request));

        $itensSaved = [];

        $collection->each(function($item, $key) use($itensSaved){
            $celebrationPriceItem = CelebrationPriceItem::create([
                "checkin" => $item->date,
                "sku" => $item->sku,
                "bedroom" => $item->code,
                "bedroomName" => $item->room,
                "minNights" =>$item->minNights,
                "cost" => $item->price,
                "status" => 1,
            ]);
            array_push($itensSaved, $celebrationPriceItem);
        });
            
        $response = response()->json($itensSaved);

        return $response;
    }
}