<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;

class ImageController extends Controller
{
    public function show($folder, $itemId, $filename)
    {
        
        $path =  storage_path("app/public/".$folder."/".$itemId."/".$filename);

        if (!File::exists($path)) {
            return response(null, 404);
        }

        $file = File::get($path);
        $type = File::mimeType($path);
        $response = response($file, 200);
        $response->header("Content-Type", $type);
        return $response;
    }

    public function deleteImageGroup(Request $request, User $analysis, $group, $filename)
    {
        $path =  storage_path("app/public/analysis/". $analysis->id."/".$group."/".$filename);

        if (!File::exists($path)) {
            return response(null, 404);
        }
        File::delete($path);
        return response("ok", 200);
    }

    public function hasImage($folder, $itemId, $filename){
        $path =  storage_path("app/public/".$folder."/".$itemId."/".$filename);

        if (!File::exists($path)) {
            return false;
        }

        return true;
    }
}
