<?php

namespace App\Http\Controllers;

use App\Models\LogUpdate;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Lang;
class LogUpdateController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $list = LogUpdate::orderBy('created_at', 'desc')->get();

        return view("log-updates/list", compact('list'));

    }


    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $rawData = $request->only(["quantity_items_updated", "user_id"]);
        
        $logItem = LogUpdate::create([
            'quantity_items_updated' => $rawData["quantity_items_updated"], 
            'user_id' => $rawData["user_id"]
        ]);

        $response = new Response();
        $response->withHeaders(['Content-Type' => "application/json"]);
        $response->setContent($logItem);

        if($logItem->id){
            $response->setStatusCode(200, Lang::get('messages.log_item_store_successful'));
        }else{
            $response->setStatusCode(400, Lang::get('messages.log_item_store_failed'));
        }

        return $response;
    }
}