<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreVpdPriceItemRequest;
use App\Http\Requests\UpdateVpdPriceItemRequest;
use App\Http\Resources\VpdPriceItemResource;
use App\Models\CelebrationPriceItem;
use App\Models\QueueUpdatedItem;
use App\Models\VpdPriceItem;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Lang;

class VpdPriceItemController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        return view("vpd-prices/list");
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create(Request $request)
    {
        return view("vpd-prices/create");

    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreVpdPriceItemRequest $request)
    {
        $rawData = $request->only([
            'checkin',
            'sku',
            'bedroom',
            'bedroomName',
            'minNights',
            'cost',
            'price',
            'priceInCash',
            'priceInSixTimes',
            'priceInSixTen',
            'bathroom',
            'status'
        ]);

        $vpdPriceItem = VpdPriceItem::create([
            'checkin' => $rawData["checkin"],
            'sku' => $rawData["sku"],
            'bedroom' => $rawData["bedroom"],
            'bedroomName' => $rawData["bedroomName"],
            'minNights' => $rawData["minNights"],
            'cost' => $rawData["cost"],
            'price' => $rawData["price"],
            'priceInCash' => $rawData["priceInCash"],
            'priceInSixTimes' => $rawData["priceInSixTimes"],
            'priceInSixTen' => $rawData["priceInSixTen"],
            'bathroom' => $rawData["bathroom"],
            'status' => $rawData["status"]
        ]);

        $response = new Response();
        $response->withHeaders(['Content-Type' => "application/json"]);
        $response->setContent($vpdPriceItem);

        if ($vpdPriceItem->id) {
            $response->setStatusCode(200, Lang::get('messages.price_item_store_successful'));
        } else {
            $response->setStatusCode(400, Lang::get('messages.price_item_store_failed'));
        }

        return $response;
    }

    /**
     * Display the specified resource.
     */
    public function show(VpdPriceItem $vpdPriceItem)
    {

        $response = new Response();
        $response->withHeaders(['Content-Type' => "application/json"]);
        $response->setContent($vpdPriceItem);

        if ($vpdPriceItem) {
            $response->setStatusCode(200, Lang::get('messages.price_item_show_successful'));
        } else {
            $response->setStatusCode(400, Lang::get('messages.price_item_show_failed'));
        }

        return $response;
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Request $request, VpdPriceItem $vpdPriceItem)
    {
        return view("celebration-prices/edit", compact("vpdPriceItem"));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateVpdPriceItemRequest $request, VpdPriceItem $vpdPriceItem)
    {
        $rawData = $request->only([
            'checkin',
            'sku',
            'bedroom',
            'bedroomName',
            'minNights',
            'cost',
            'price',
            'priceInCash',
            'priceInSixTimes',
            'priceInSixTen',
            'bathroom',
            'status'
        ]);

        $priceItemUpdated = $vpdPriceItem->fill([
            'checkin' => $rawData["checkin"],
            'sku' => $rawData["sku"],
            'bedroom' => $rawData["bedroom"],
            'bedroomName' => $rawData["bedroomName"],
            'minNights' => $rawData["minNights"],
            'cost' => $rawData["cost"],
            'price' => $rawData["price"],
            'priceInCash' => $rawData["priceInCash"],
            'priceInSixTimes' => $rawData["priceInSixTimes"],
            'priceInSixTen' => $rawData["priceInSixTen"],
            'bathroom' => $rawData["bathroom"],
            'status' => $rawData["status"]
        ])->save();

        $response = new Response();
        $response->withHeaders(['Content-Type' => "application/json"]);
        $response->setContent($vpdPriceItem);

        if ($priceItemUpdated) {
            $response->setStatusCode(200, Lang::get('messages.price_item_update_successful'));
        } else {
            $response->setStatusCode(400, Lang::get('messages.price_item_update_failed'));
        }

        return $response;
    }


    public function updateRates(Request $request){
        $rawData = $request->only([
            'priceInCash',
            'priceInSixTimes',
            'priceInTenTimes',
        ]);

        $list = VpdPriceItem::all();
        $count = 0;

        foreach ($list as $item){

            $dataToUpdate = [];
            if(isset($rawData["priceInCash"])){
                $dataToUpdate["priceInCash"] = $rawData["priceInCash"];
            }
            if(isset($rawData["priceInSixTimes"])){
                $dataToUpdate["priceInSixTimes"] = $rawData["priceInSixTimes"];
            }
            if(isset($rawData["priceInTenTimes"])){
                $dataToUpdate["priceInTenTimes"] = $rawData["priceInTenTimes"];
            }
            $updated = $item->fill($dataToUpdate)->save();
            
            if ($updated){
                $count++;
            }
        }

        return redirect()
            ->route("listVpdPriceItem")
            ->with("hasMessage", true)
            ->with("messageType", ($count > 0) ? "success" : "warning")
            ->with("message", ($count  > 0) ? Lang::get('messages.price_item_delete_successful') : Lang::get('messages.price_item_delete_failed'));
    }



    
    /**
     * Remove the specified resource from storage.
     */
    public function destroy(VpdPriceItem $vpdPriceItem)
    {
        $deleted = $vpdPriceItem->delete();

        return redirect()
            ->route("deleteVpdPriceItem")
            ->with("hasMessage", true)
            ->with("messageType", ($deleted === true) ? "success" : "warning")
            ->with("message", ($deleted === true) ? Lang::get('messages.price_item_delete_successful') : Lang::get('messages.price_item_delete_failed'));
    }

    public function listData(Request $request)
    {
        $draw = $request->get('draw');
        $start = $request->get('start');
        $length = $request->get('length');

        $per_page = $start;
        
        $current_page = $start == 0 ? 1 : (($start/$length))+1 ;
        $starting_point = $start;//($current_page * $per_page) - $per_page;
        $items = VpdPriceItem::offset($starting_point)->limit($length)->get();
        $total = $items->count();

        $additional = [
            "total" => VpdPriceItem::count(),
            "per_page" => $per_page,
            "current_page" => $current_page
        ];

        $celebrationPriceItemResource = new VpdPriceItemResource($items);

        $celebrationPriceItemResource->additional($additional);

        $response = response()->json($celebrationPriceItemResource);

        return $response;
    }


    public function importCelebrationPrices(Request $request)
    {
        VpdPriceItem::truncate();

        $items = CelebrationPriceItem::all();
        $count = 0;
        foreach ($items as $item) {
            $vpdPriceItem = VpdPriceItem::create([
                'checkin' => $item->checkin,
                'sku' => $item->sku,
                'bedroom' => $item->bedroom,
                'bedroomName' => $item->bedroomName,
                'minNights' => $item->minNights,
                'cost' => $item->cost,
                'price' => number_format(($item->cost/(1 - 0.0185 - 0.04)),2),
                'status' => $item->status
            ]);

            if ($vpdPriceItem) {
                $count++;
            }

        }
        $response = response()->json(["quantityItemsAdded" => $count]);

        return $response;
    }

    public function importUpdatedPrices(Request $request)
    {
        $items = QueueUpdatedItem::where("processed_at", null)->orderBy("created_at", "asc")->get();

        $count = 0;
         foreach ($items as $queueUpdatedItem) {

            $dataToUpdate = [];
            if(isset($queueUpdatedItem->cost)){
                $dataToUpdate["cost"] = $queueUpdatedItem->cost;
                $dataToUpdate["price"] = (float)number_format((floatval($queueUpdatedItem->cost))/(1 - 0.0185 - 0.04),2);
            }
            if(isset($queueUpdatedItem->status)){
                $dataToUpdate["status"] = $queueUpdatedItem->status;
            }
            $vpdPriceItem = VpdPriceItem::where("sku", $queueUpdatedItem->sku)->first();
            $wasUpdated = $vpdPriceItem->fill($dataToUpdate)->save();

            
            if ($wasUpdated) {
                $queueUpdatedItem->fill(["processed_at" => date("Y-m-d H:i:s")])->save();
                $count++;
            }

         }
        $response = response()->json(["quantityItemsAdded" => $count]);

        return $response;
    }
}