<?php

namespace App\Http\Services;

use Carbon\Carbon;
use Google\Client;
use Google\Service\Sheets;
use Illuminate\Http\Request;
use stdClass;

class GoogleSheetsIntegrationService
{
    public function index(Request $request){
                
        $client = new Client();
        $client->setApplicationName('VPDTravel - Relatório');
        $client->addScope(Sheets::SPREADSHEETS);
        $client->setAuthConfig(base_path() . "/public/vpdtravel-d7651fd17aa9.json");
        $idSheet = env("GOOGLE_SHEETS_ID");

        $service = new Sheets($client);
        $sheet = $service->spreadsheets_values->get($idSheet, "Resumo Criaturo");
        
      
        $rowHeader = [];

        foreach($sheet->values as $key => $item){
            if($key > 0 && isset($item[0])){
                $objItem = $this->buildItem($item);
                array_push($rowHeader, $objItem);
            }

        }
        
        return $rowHeader;   
    }

    private function buildItem($arrItem){
        $line = new stdClass;
        $line->date = Carbon::parse($this->convertDate($arrItem[0]))->format("Y-m-d H:i:s");
        $line->sku = $arrItem[1];
        $line->code = $arrItem[2];
        $line->room = $arrItem[3];
        $line->minNights = $arrItem[4];
        $line->price = $this->convertCoin($arrItem[5]);

        return $line;
    }


    public function convertDate($date){
        if(isset($date)){
            $date = explode("/", $date);
            return $date[2]."-".$date[1]."-".$date[0];
        }else{
            return null;
        }
    }

    private function convertCoin($coin){
        $coin = str_replace(",", ".", $coin);
        return $coin;
    }
    
}
