<?php

namespace App\Observers;

use App\Models\CelebrationPriceItem;
use App\Models\QueueUpdatedItem;
use Illuminate\Support\Facades\Log;

class CelebrationItemPriceObserver
{
    /**
     * Handle the CelebrationPriceItem "created" event.
     */
    public function created(CelebrationPriceItem $celebrationPriceItem): void
    {
        //
    }

    /**
     * Handle the CelebrationPriceItem "updated" event.
     */
    public function updated(CelebrationPriceItem $celebrationPriceItem): void
    {
        Log::info("price updated for celebration", [$celebrationPriceItem]);
        $queueUpdatedItem = new QueueUpdatedItem();
        $queueUpdatedItem->sku = $celebrationPriceItem->sku;
        $queueUpdatedItem->bedroom = $celebrationPriceItem->bedroom;
        $queueUpdatedItem->bedroomName = $celebrationPriceItem->bedroomName;
        $queueUpdatedItem->minNights = $celebrationPriceItem->minNights;
        $queueUpdatedItem->cost = $celebrationPriceItem->cost;
        $queueUpdatedItem->status = $celebrationPriceItem->status;
        
        $queueUpdatedItem->save();
        
    }

    /**
     * Handle the CelebrationPriceItem "deleted" event.
     */
    public function deleted(CelebrationPriceItem $celebrationPriceItem): void
    {
        //
    }

    /**
     * Handle the CelebrationPriceItem "restored" event.
     */
    public function restored(CelebrationPriceItem $celebrationPriceItem): void
    {
        //
    }

    /**
     * Handle the CelebrationPriceItem "force deleted" event.
     */
    public function forceDeleted(CelebrationPriceItem $celebrationPriceItem): void
    {
        //
    }
}
