<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table("users", function(Blueprint $table){
            $table->unsignedBigInteger("permission_id")->after("password");
            $table->foreign("permission_id")
                  ->references("id")
                  ->on("permissions")
                  ->onDelete("SET NULL");
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table("users", function(Blueprint $table){
            $table->dropForeign("permission_id");
            $table->dropColumn("permission_id");
        });
    }
};
