<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('vpd_price_items', function (Blueprint $table) {
            $table->id();
            $table->date("checkin");
            $table->string("sku");
            $table->string("bedroom");
            $table->string("bedroomName");
            $table->integer("minNights");
            $table->double("cost",10,6);
            $table->double("price",10,6)->nullable();
            $table->double("priceInCash",10,6)->nullable();
            $table->double("priceInSixTimes",10,6)->nullable();
            $table->double("priceInTenTimes",10,6)->nullable();
            $table->integer("bathroom")->nullable();
            $table->boolean("status");
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('vpd_price_items');
    }
};
