<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('queue_updated_items', function (Blueprint $table) {
            $table->id();
            $table->dateTime("processed_at")->nullable();
            $table->string("sku");
            $table->string("bedroom");
            $table->string("bedroomName");
            $table->integer("minNights");
            $table->double("cost",10,6);
            $table->boolean("status");
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('queue_updated_items');
    }
};
