<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('log_updates', function (Blueprint $table) {
            $table->id();
            $table->integer("quantity_items_updated");
            $table->unsignedBigInteger("user_id");
            $table->foreign("user_id")
                  ->references("id")
                  ->on("users")
                  ->onDelete("SET NULL");
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('log_updates');
    }
};
