Global =
{
    PageLoad: function () {

        Global.ConfiguraControles();

    },
    ConfiguraControles: function () {
            $('.seguranca_masking').mask('999?9');

            $('.cartao_masking').mask('9999.9999.9999.9999');

            $('.mes_masking').mask('99');

            $('.ano_masking').mask('9999');

            $('.validity_masking').mask("99/2099")

            $('.date_masking').mask('99/99/9999');

            $('.dateNasc_masking').mask('99/99/9999');

            $(".phone_masking")
                .mask("(99) 9999-9999?9")
                .focusout(function (event) {  
                    var target, phone, element;  
                    target = (event.currentTarget) ? event.currentTarget : event.srcElement;  
                    phone = target.value.replace(/\D/g, '');
                    element = $(target);  
                    element.unmask();  
                    if(phone.length > 10) {  
                        element.mask("(99) 99999-999?9");  
                    } else {  
                        element.mask("(99) 9999-9999?9");  
                    }  
                });
           
            $(".maskMoney").maskMoney();
            
            $('.cpf_masking').mask('999.999.999-99');

            $('.cnpj_masking').mask('99.999.999/9999-99');

            $('.placa_masking').mask('aaa-9999');

            $('.cep_masking').mask('99999-999');
    },
    ValidaEmail: function validateEmail(field) {
        var regex = /^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,5}$/;
        return (regex.test(field)) ? true : false;
    },
    ValidaCartao: function (numero)
    {
        for (var cartao in cartoes) {
            if (numero.match(cartoes[cartao]))
                return true;
        }
        return false;
    },
    RetornaCartao: function (numero){
        for (var cartao in cartoes) {
            if (numero.match(cartoes[cartao]))
                return cartao;
        }
        return null;
    },
    FormataMoeda: function (valor, tipo) {
        if (tipo == "USD") {
            valor = valor.toString();
            valor = valor.replace(".", "");
            valor = valor.replace(",", ".");
            valor = parseFloat(valor).toFixed(2);
            return valor;
        }else if(tipo == "BRL") {
            valor = parseFloat(valor).toFixed(2);
            valor = valor.toString();
            valor = valor.replace(",", ";");
            valor = valor.replace(".", ",");
            valor = valor.replace(";", ".");
            return valor;
        }
        return null;
    },
    BuscaCep:function(data,address,neighborhood,city, state) {

        //Nova variável "cep" somente com dígitos.
        var cep = data.replace(/\D/g, '');

        //Verifica se campo cep possui valor informado.
        if (cep != "") {

            //Expressão regular para validar o CEP.
            var validacep = /^[0-9]{8}$/;

            //Valida o formato do CEP.
            if (validacep.test(cep)) {

                //Preenche os campos com "..." enquanto consulta webservice.
                $(address).val("...");
                $(neighborhood).val("...");
                $(city).val("...");
                $(state).val("...");

                $.getJSON("//viacep.com.br/ws/" + cep + "/json/?callback=?", function (dados) {

                    if (!("erro" in dados)) {
                        $(address).val(dados.logradouro);
                        $(neighborhood).val(dados.bairro);
                        $(city).val(dados.localidade);
                        $(state).val(dados.uf);
                    }
                    else {
                        //CEP pesquisado não foi encontrado.
                        Global.LimpaDadosEndereco(address,neighborhood,city, state);
                    }
                });
            } else {
                //cep é inválido.
                Global.LimpaDadosEndereco(address,neighborhood,city, state);
            }
        } //end if.
        else {
            //cep sem valor, limpa formulário.
            Global.LimpaDadosEndereco(address,neighborhood,city, state);
        }
    },
    LimpaDadosEndereco: function(address,neighborhood,city, state) {
        $(address).val("");
        $(neighborhood).val("");
        $(city).val("");
        $(state).val("");
    }
}
var cartoes =
{
    Visa: /^4[0-9]{12}(?:[0-9]{3})/,
    MasterCard: /^5[1-5][0-9]{14}/,
    Amex: /^3[47][0-9]{13}/,
    Diners: /^3(?:0[0-5]|[68][0-9])[0-9]{11}/,
    Discover: /^6(?:011|5[0-9]{2})[0-9]{12}/,
    JCB: /^(?:2131|1800|35\d{3})\d{11}/
};

$(function () {
    Global.PageLoad();

    
});