$(document).ready(function(){
    Dropzone.autoDiscover = false;
    $("#filesDropzone").dropzone({ 
        url: base_url + 'painel-administrativo/cabines/salvar',
        autoProcessQueue: false,
        uploadMultiple: true,
        maxFilesize: 1,
        acceptedFiles: 'image/*',
        addRemoveLinks: true,
        paramName: 'file',
        init: function() {
            let dzClosure = this; // Makes sure that 'this' is understood inside the functions below.
    
            // for Dropzone to process the queue (instead of default form behavior):
            document.getElementById("btnStore").addEventListener("click", function(e) {
                // Make sure that the form isn't actually being sent.
                e.preventDefault();
                e.stopPropagation();
                dzClosure.processQueue();
            });
    
            //send all the form data along with the files:
            this.on("sendingmultiple", function(data, xhr, formData) {
                if($("input[name='hId']").val() !== undefined){
                    formData.append("hId", $("input[name='hId']").val());
                }
                formData.append("sltShip", $("#sltShip").val());
                formData.append("txtCategory", $("#txtCategory").val());
                formData.append("txtName", $("#txtName").val());
                formData.append("txtSize", $("#txtSize").val());
               
            });

            this.on("successmultiple",function(response,xhr){
                processResponse(response[0].xhr.response);
            });
        }
    });

    function processResponse(response){
        
        let objResponse = JSON.parse(response);

        window.location.href = objResponse.urlRedirect;
    }
});