$(document).ready(function () {
    let objEdit = undefined;

    $.fn.dataTableExt.errMode = 'ignore';

    let table = $("#customTable").DataTable({
        ajax: {
            url: urlCelebrationPrices + '/list-data',
            type: 'POST',
            "complete": function (json, type) {
                changeFields();
            }
        },
        processing: true,
        serverSide: true,
        columns: [
            { data: 'id' },
            { data: 'checkin' },
            { data: 'bedroom' },
            { data: 'minNights' },
            { data: 'cost', "render": function (data, type, row, meta)
                {
                    if (data == "null")
                    {
                        return "<input type='text' class='price_mask form-control ' />";
                    }
                    else
                    {
                        return "<input type='text' data-id='"+ row.id +"' id='cost-" + row.id + "' class='price_mask form-control cost' value='" +data+ "'/>";
                    }
                } 
            },
            { data: 'status', "render": function (data, type, row, meta)
                {
        
                    if (data == 1)
                    {
                        return '<input type="checkbox" data-id="'+ row.id +'" id="status-'+row.id+'" class="status" value="1" checked>';
                    }
                    else
                    {
                        return '<input type="checkbox" data-id="'+ row.id +'" id="status-'+row.id+'" class="status" value="0" >';
                    }
                } 
            },
        ]
    });

    function changeFields(){
        $(".cost, .status").on('change', function (e) {
            $(this).closest("tr").addClass("updated");
        });
    }

    table.on('click', 'button', function (e) {
        let data = table.row(e.target.closest('tr')).data();

        objEdit = data;

        buildDataInForm(objEdit);
        jQuery("#modelEdit").modal("toggle");
    });

    function buildDataInForm(dataFields){
        let form = $('form#frmEdit');
        form.find('#checkin').val(dataFields.checkin);
        form.find('#bedroom').val(dataFields.bedroom);
        form.find('#minNights').val(dataFields.minNights);
        form.find('#cost').val(dataFields.cost);
        form.find('#status').val(dataFields.status);
        form.find('#id').val(dataFields.id);
    }

    $(".btn-save-items").on('click', saveItems);
    
    function saveItems (e) {
        e.preventDefault();
        let items = [];
        $("#customTable").find('tr').each(function (idx) {
            if(idx > 0){
                let item = $(this);
                if( item.hasClass("updated")){
                    items.push({ "id": item.find(".cost").data("id"), "cost": item.find(".cost").val(), "status": item.find(".status").is(":checked")? 1 : 0 });
                }
            }
        })

        Swal.fire({
            title: "Are you sure?",
            text: "",
            icon: "warning",
            confirmButtonText: "Yes",
            cancelButtonText: "No",
            showCancelButton: true,
            reverseButtons: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            dangerMode: true,
          }).then(function(result) {
            if (result.isConfirmed) {
                $.ajax({
                    url: urlCelebrationPrices + '/update-batch',
                    type: 'PUT',
                    data: JSON.stringify({"items": items, "userId": userId}),
                    success: function (data) {
                        
                        objEdit = undefined;
                        Swal.fire({
                            title: 'Success!',
                            text: "Was updated " + data.length+" items.",
                            icon: 'success'
                        }).then(function () {
                            window.location.reload();
                        })
                    },
                    error: function (data) {
                        Swal.fire({
                            title: 'Error!',
                            text: data,
                            icon: 'error'
                        }).then(function () {
                            window.location.reload();
                        })
                    }
                });
            } 
          })

        
    }

    $("#btnSave").on('click', saveItem);

    function saveItem (e) {
        e.preventDefault();
        let id = $("form#frmEdit").find("#id").val();
        $.ajax({
            url: urlCelebrationPrices + '/update/' + id,
            type: 'PUT',
            data: $('form#frmEdit').serialize(),
            success: function (data) {
                jQuery("#modelEdit").modal("toggle");
                table.ajax.reload();
                objEdit = undefined;
                Swal.fire({
                    title: 'Success!',
                    text: data,
                    icon: 'success'
                })
            },
            error: function (data) {
                Swal.fire({
                    title: 'Error!',
                    text: data,
                    icon: 'error'
                })
            }
        });
    }
});