$(document).ready(function () {
    let objEdit = undefined;

    //$.fn.dataTableExt.errMode = 'ignore';

    let table = $("#customTable").DataTable({
        autoWidth: true,
        ajax: {
            url: urlVpdPrices + '/list-data',
            type: 'POST',
            "complete": function (json, type) {
                changeFields();
            }
        },
        "lengthChange": true,
        processing: true,
        serverSide: true,
        columns: [
            { data: 'id' },
            { data: 'checkin' },
            { data: 'sku' },
            {
                data: 'bedroom', "render": function (data, type, row, meta) {
                    if (data != "null") {
                        return "<span>" + row.bedroom + "</span><br/>" +
                            "<span>" + row.bedroomName + "</span>";
                    }
                }
            },
            { data: 'minNights' },
            {
                data: 'cost', "render": function (data, type, row, meta) {

                    if (data != "null") {
                       
                        return  "$"+(data == null ? "" : data);
                    }
                }
            },
            {
                data: 'price', "render": function (data, type, row, meta) {

                    if (data != "null") {
                       
                        return  "$" + (data == null ? "" : data);
                    }
                }
            },
            {
                data: 'priceInCash', "render": function (data, type, row, meta) {
                    if (data != "null") {
                        price = ((row.cost) / (1 - 0.035 - 0.067));
                        return  "$" +(row.priceInCash == null ? "" : price.toFixed(2)) + "<input type='hidden' class='rate-in-cash' value='0.067' />";
                    }
                }
            },
            {
                data: 'priceInSixTimes', "render": function (data, type, row, meta) {
                    if (data != "null") {
                       
                        price = ((row.cost) / (1 - 0.072 - 0.069));

                        return  "$" +(row.priceInSixTimes == null ? "" : price.toFixed(2))+ "<input type='hidden' class='rate-in-six-times' value='0.069' />";
                    }
                }
            },
            {
                data: 'priceInTenTimes', "render": function (data, type, row, meta) {
                    if (data != "null") {
                       
                        price = ((row.cost) / (1 - 0.1120 - 0.072));

                        return  "$" +(row.priceInTenTimes == null ? "" : price.toFixed(2))+ "<input type='hidden' class='rate-in-ten-times' value='0.072' />";
                    }
                }
            },
            { data: 'bathrooms' },
            {
                data: 'status', "render": function (data, type, row, meta) {

                    if (data == 1) {
                        return '<input type="checkbox" data-id="' + row.id + '" id="status-' + row.id + '" class="status" value="1" checked>';
                    }
                    else {
                        return '<input type="checkbox" data-id="' + row.id + '" id="status-' + row.id + '" class="status" value="0" >';
                    }
                }
            },
        ],
        createdRow: (row, data, index) => {
            if (moment().diff(data.updated_at,"d") < 3) {
                row.classList.add('row-updated');
            }
        }
    });

    function changeFields() {
        $(".cost, .status").on('change', function (e) {
            $(this).closest("tr").addClass("updated");
        });
    }

    // table.on('click', 'button', function (e) {
    //     let data = table.row(e.target.closest('tr')).data();

    //     objEdit = data;

    //     buildDataInForm(objEdit);
    //     jQuery("#modelEdit").modal("toggle");
    // });

    function buildDataInForm(dataFields) {
        let form = $('form#frmEdit');
        form.find('#checkin').val(dataFields.checkin);
        form.find('#bedroom').val(dataFields.bedroom);
        form.find('#minNights').val(dataFields.minNights);
        form.find('#cost').val(dataFields.cost);
        form.find('#status').val(dataFields.status);
        form.find('#id').val(dataFields.id);
    }

    $(".btn-import-celebration-prices").on('click', importCelebrationPrices);
    $(".btn-import-updated-prices").on('click', importUpdates);
    $(".btn-save-items").on('click', saveItems);
    $("#btnSave").on('click', saveItem);
    $(".btn-export").on('click', exportItems);
    $(".btn-import-celebration-prices").hide();

    function saveItems(e) {
        e.preventDefault();
        let items = [];
        $("#customTable").find('tr').each(function (idx) {
            if (idx > 0) {
                let item = $(this);
                if (item.hasClass("updated")) {
                    items.push({ "id": item.find(".cost").data("id"), "cost": item.find(".cost").val(), "status": item.find(".status").is(":checked") ? 1 : 0 });
                }
            }
        })

        Swal.fire({
            title: "Are you sure?",
            text: "",
            icon: "warning",
            confirmButtonText: "Yes",
            cancelButtonText: "No",
            showCancelButton: true,
            reverseButtons: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            dangerMode: true,
        }).then(function (result) {
            if (result.isConfirmed) {
                $.ajax({
                    url: urlCelebrationPrices + '/update-batch',
                    type: 'PUT',
                    data: JSON.stringify({ "items": items, "userId": userId }),
                    success: function (data) {
                        
                        objEdit = undefined;
                        Swal.fire({
                            title: 'Success!',
                            text: "Was updated " + data.length + " items.",
                            icon: 'success'
                        })
                        $("#customTable").ajax.reload();
                    },
                    error: function (data) {
                        Swal.fire({
                            title: 'Error!',
                            text: data,
                            icon: 'error'
                        })
                    }
                });
            }
        })


    }

    function saveItem(e) {
        e.preventDefault();
        let id = $("form#frmEdit").find("#id").val();
        $.ajax({
            url: urlCelebrationPrices + '/update/' + id,
            type: 'PUT',
            data: $('form#frmEdit').serialize(),
            success: function (data) {
                jQuery("#modelEdit").modal("toggle");
                table.ajax.reload();
                objEdit = undefined;
                Swal.fire({
                    title: 'Success!',
                    text: data,
                    icon: 'success'
                })
            },
            error: function (data) {
                Swal.fire({
                    title: 'Error!',
                    text: data,
                    icon: 'error'
                })
            }
        });
    }

    function importCelebrationPrices(e) {
        e.preventDefault();

        Swal.fire({
            title: "Are you sure?",
            text: "",
            icon: "warning",
            confirmButtonText: "Yes",
            cancelButtonText: "No",
            showCancelButton: true,
            reverseButtons: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            dangerMode: true,
        }).then(function (result) {
            if (result.isConfirmed) {
                $.ajax({
                    url: urlVpdPrices + '/import-celebration-prices',
                    type: 'POST',
                    data: JSON.stringify({ "userId": userId }),
                    success: function (data) {

                        window.location.reload();

                    }
                });

            }
        });

    }

    function importUpdates(e) {
        e.preventDefault();

        Swal.fire({
            title: "Are you sure?",
            text: "",
            icon: "warning",
            confirmButtonText: "Yes",
            cancelButtonText: "No",
            showCancelButton: true,
            reverseButtons: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            dangerMode: true,
        }).then(function (result) {
            if (result.isConfirmed) {
                $.ajax({
                    url: urlVpdPrices + '/import-updated-prices',
                    type: 'POST',
                    success: function (data) {
                        debugger;
                        if(data.quantityItemsAdded > 0){
                            Swal.fire({
                                icon: 'success',
                                title: 'Items updated',
                            })
                        }else{
                            Swal.fire({
                                icon: 'error',
                                title: 'Try again',
                            }) 
                        }

                    }
                });

            }
        });

    }

    function exportItems(e) {
        e.preventDefault();
        Swal.fire({
            title: 'Success!',
            text: data,
            icon: 'success'
        })
    }
});