<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>{{env("APP_NAME")}} | @yield('pageTitle')</title>
    <!-- Favicon icon -->
    <link rel="icon" type="image/png" sizes="16x16" href="{{asset("/assets/images/favicon.ico")}}">

    <script
    src="https://code.jquery.com/jquery-1.12.4.min.js"
    integrity="sha256-ZosEbRLbNQzLpnKIkEdrPv7lOy9C27hHQ+Xp8a4MxAQ="
    crossorigin="anonymous"></script>
    {{-- <script
    src="https://code.jquery.com/jquery-2.2.4.min.js"
    integrity="sha256-BbhdlvQf/xTY9gja0Dq3HiwQF8LaCRTXxZKRutelT44="
    crossorigin="anonymous"></script> --}}
    <!-- Bootstrap Core CSS -->
    <link href="{{asset("/assets/bootstrap/dist/css/bootstrap.min.css")}}" rel="stylesheet">
    <!-- animation CSS -->
    <link href="{{asset("/assets/css/animate.min.css")}}" rel="stylesheet">
    <!-- Custom CSS -->
    <link href="{{asset("/assets/css/style.min.css")}}" rel="stylesheet">
    <link href="{{asset("/assets/css/application.css")}}" rel="stylesheet">
    <!-- color CSS -->
    <link href="{{asset("/assets/css/colors/yellow.css")}}" id="theme" rel="stylesheet">

    @stack("styles")
</head>
<body ng-app="VPDApp">
    <!-- Preloader -->
    <div class="preloader">
        <div class="cssload-speeding-wheel"></div>
    </div>
    <div id="wrapper">
        <!-- Top Navigation -->
        <nav class="navbar navbar-default navbar-static-top m-b-0">
            <div class="navbar-header">
                <a class="navbar-toggle hidden-sm hidden-md hidden-lg " href="javascript:void(0)" data-toggle="collapse" data-target=".navbar-collapse"><i class="ti-menu"></i></a>
                <div class="top-left-part">
                    <a class="logo" href="{{url("painel-administrativo/dashboard")}}">
                        <img src="{{asset("assets/images/logo-topo.png")}}" alt="home" />
                    </a>
                </div>
                <ul class="nav navbar-top-links navbar-left hidden-xs">
                    <li><a href="javascript:void(0)" class="open-close hidden-xs waves-effect waves-light"><i class="icon-arrow-left-circle ti-menu"></i></a></li>
                    <li>
                        <form role="search" class="app-search hidden-xs">
                            <input type="text" placeholder="Buscar..." class="form-control">
                            <a href=""><i class="fa fa-search"></i></a>
                        </form>
                    </li>
                </ul>
                <ul class="nav navbar-top-links navbar-right pull-right">
                    <li class="dropdown">
                        <a class="dropdown-toggle profile-pic" data-toggle="dropdown" href="#">
                            <img src="{{asset(Auth::user()->image ?? "/assets/plugins/images/users/varun.jpg")}}" alt="user-img" width="36" class="img-circle">
                            <b class="hidden-xs">{{Auth::user()->name}}</b>
                        </a>
                        <ul class="dropdown-menu dropdown-user animated flipInY">
                            <li><a href="#"><i class="ti-user"></i> Meu Perfil</a></li>
                            <li><a href="#"><i class="ti-wallet"></i> Meus Pedidos</a></li>
                            <li><a href="#"><i class="ti-email"></i> Mensagens</a></li>
                            <li role="separator" class="divider"></li>
                            <li><a href="{{url("logout")}}"><i class="fa fa-power-off"></i> Sair</a></li>
                        </ul>
                    </li>
                </ul>
            </div>
        </nav>
        <div class="navbar-default sidebar" role="navigation">
            <div class="sidebar-nav navbar-collapse slimscrollsidebar">
                <ul class="nav" id="side-menu">
                    <li><a href="{{url("dashboard")}}" class="waves-effect"><i class=" icon-home" data-icon="v"></i> <span class="hide-menu">Dashboard</span></a></li>
                    <li>
                        <a href="{{url("admin/prices-table")}}" class="waves-effect">
                            <i class="vpd-icon-tickets"></i>
                            <span class="hide-menu">Prices
                                <span class="fa arrow"></span>
                            </span>
                        </a>
                        <ul class="nav nav-second-level">
                            <li><a href="{{url("admin/celebrations-prices-table")}}">Prices Table</a></li>
                            @if(Auth::user()->permission->name === 'Root')
                            <li><a href="{{url("admin/log-updates-table")}}">Log Updates</a></li>
                            <li><a href="{{url("admin/vpd-prices-table")}}">VPD Prices Table</a></li>
                            @endif
                        </ul>
                    </li>
                    @if(Auth::user()->permission->name === 'Root')

                    <li>
                        <a href="{{url("admin/configurations")}}" class="waves-effect">
                            <i class="vpd-icon-tickets"></i>
                            <span class="hide-menu">Configurations
                                <span class="fa arrow"></span>
                            </span>
                        </a>
                        <ul class="nav nav-second-level">
                            <li><a href="{{url("admin/usuarios")}}">Users</a></li>
                        </ul>
                    </li>
                    @endif
                </ul>
            </div>
        </div>
        <div id="page-wrapper">
            <div class="container-fluid">
                <div class="row bg-title">
                    <!-- .page title -->
                    <div class="col-lg-3 col-md-4 col-sm-4 col-xs-12">
                        <h4 class="page-title">@yield("pageTitle")</h4>
                    </div>
                    <div class="col-lg-9 col-sm-8 col-md-8 col-xs-12">
                        @yield('breadcrumb')
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        @yield('content')
                    </div>
                </div>
            </div>
            <footer class="footer text-center"> <?= date("Y")?> &copy; VPD Orlando </footer>            
        </div>
    </div>
 
    <!-- Bootstrap Core JavaScript -->
    <script src="{{asset("/assets/bootstrap/dist/js/bootstrap.min.js")}}"></script>
    <!-- Menu Plugin JavaScript -->
    <script src="{{asset("/assets/plugins/bower_components/sidebar-nav/dist/sidebar-nav.min.js")}}"></script>
    <!--slimscroll JavaScript -->
    <script src="{{asset("/assets/js/jquery.slimscroll.js")}}"></script>

    <script src="//cdn.jsdelivr.net/npm/sweetalert2@10"></script>
    <!--Wave Effects -->
    <script src="{{asset("/assets/js/waves.js")}}"></script>
    <!-- Custom Theme JavaScript -->
    <script src="{{asset("/assets/js/custom.min.js")}}"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/angular.js/1.8.3/angular.min.js" integrity="sha512-KZmyTq3PLx9EZl0RHShHQuXtrvdJ+m35tuOiwlcZfs/rE7NZv29ygNA8SFCkMXTnYZQK2OX0Gm2qKGfvWEtRXA==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/angular-sanitize/1.8.3/angular-sanitize.min.js" integrity="sha512-dqbRITjlgYAKHWHwL8fK7VPOsFc702ybywomtYLRcjOzBHM3WgEGN0SQQR6IJKY4ZiJiZkNguOAcFZmalk+2sA==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script src="{{asset("/assets/js/app/app.js")}}"></script>
    <script type="text/javascript">
        var base_url = "{{url("")}}";
        var userId = "{{ Auth::user()->id }}";
    </script>
    @stack("scripts")
</body>
</html>