<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>{{env("APP_NAME")}} | @yield('pageTitle')</title>
    <!-- Favicon icon -->
    <link rel="icon" type="image/png" sizes="16x16" href="{{asset("/assets/images/favicon.ico")}}">
    <!-- fonts -->

    <script src="https://code.jquery.com/jquery-2.2.4.min.js" integrity="sha256-BbhdlvQf/xTY9gja0Dq3HiwQF8LaCRTXxZKRutelT44=" crossorigin="anonymous"></script>

    <meta name="csrf-token" content="{{ csrf_token() }}">

    <link href="{{asset("assets/bootstrap/dist/css/bootstrap.min.css")}}" rel="stylesheet">
    <link href="{{asset("assets/css/animate.css")}}" rel="stylesheet">
    <link href="{{asset("assets/css/style.css")}}" rel="stylesheet">
    <link href="{{asset("assets/css/application.css")}}" rel="stylesheet">
    <link href="{{asset("assets/css/colors/blue.css")}}" id="theme" rel="stylesheet">
  
    <script type="text/javascript">
        var base_url = "{{url("/")}}";
    </script>

    @stack("styles")
</head>

<body>
    <!-- Preloader -->
    <div class="preloader">
        <div class="cssload-speeding-wheel"></div>
      </div>

    @yield("content")


    <script src="{{asset("assets/bootstrap/dist/js/bootstrap.min.js")}}"></script>
    <script src="{{asset("assets/plugins/bower_components/sidebar-nav/dist/sidebar-nav.min.js")}}"></script>
    <script src="{{asset("assets/js/jquery.slimscroll.js")}}"></script>
    <script src="{{asset("assets/js/waves.js")}}"></script>
    <script src="{{asset("assets/js/custom.min.js")}}"></script>

    @stack("scripts")
</body>

</html>