<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>Abecam | @yield('pageTitle')</title>
    <!-- Favicon icon -->
    <link rel="icon" type="image/png" sizes="16x16" href="{{asset("/assets/images/favicon.ico")}}">
    <!-- fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Ubuntu:wght@300;400;500;700&display=swap" rel="stylesheet">
    <link href="{{asset("/assets/css/style.css")}}" rel="stylesheet">
    <script src="{{asset("/assets/js/modernizr-3.6.0.min.js")}}"></script>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    @stack("styles")
</head>

<body class="login-page">
    <div id="preloader">
        <div class="loader">
            <svg class="circular" viewBox="25 25 50 50"><circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="3" stroke-miterlimit="10"/></svg>
        </div>
    </div>

    @yield("content")
    <script src="//cdn.jsdelivr.net/npm/sweetalert2@10"></script>
    <!-- Common JS -->
    <script src="{{asset("/assets/plugins/common/common.min.js")}}"></script>
    <!-- Custom script -->
    <script src="{{asset("/assets/js/custom.min.js")}}"></script>
    <!-- Chartjs chart -->
    <script src="{{asset("/assets/plugins/chartjs/Chart.bundle.js")}}"></script>
    <!-- Custom dashboard script -->
    <script src="{{asset("/assets/js/dashboard-1.js")}}"></script>

    @stack("scripts")
</body>

</html>