@extends('layouts.app')
@section("pageTitle", "Log Updates")

@push("styles")

{{-- <link rel="stylesheet" href="//cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css"> --}}
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap.min.css">
@endpush

@section("content")
<div class="white-box">

    <h3 class="box-title m-b-0">Log Updates</h3>
    @if(session("hasMessage") != "")
        @component('components.alert')
                @slot("type")
                    {{session("messageType")}}
                @endslot
                @slot("message")
                    {{session("message")}}
                @endslot
        @endcomponent
    @endif
    <table class="table color-table info-table display" id="customTable" style="width:100%">
        <thead>
            <tr>
                <th>#</th>
                <th>Date</th>
                <th>Quantity Items Updated</th>
                <th>User</th>
              
            </tr>
        </thead>
        <tbody>
            @foreach ($list as $log)    
            <tr>
                <td>{{ $log->id }}</td>
                <td>{{ \Carbon\Carbon::parse($log->created_at)->format("Y-m-d H:i:s") }}</td>
                <td>{{ $log->quantity_items_updated }}</td>

                <td>{{ $log->user->name }}</td>
                
            </tr>
            @endforeach
        </tbody>
    </table>

   
</div>
@endsection

@push("scripts")
<script src="//cdn.jsdelivr.net/npm/sweetalert2@10"></script>
<script type="text/javascript">
    let urlCelebrationPrices = '<?= url("api/celeration-prices-item") ?>';
</script>

@endpush