@extends('layouts.app')
@section("pageTitle", "Criação de Usuários")

@push("styles")
<link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/jasny-bootstrap/4.0.0/css/jasny-bootstrap.min.css">
@endpush

@section("content")

<div class="white-box">
    <p class="text-muted m-b-30 font-13"></p>

    @if ($errors->any())
        @component('components.alert')
            @slot("type")
                danger
            @endslot
            @slot("message")
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            @endslot
        @endcomponent
    @endif
    @if(session("hasMessage") != "")
        @component('components.alert')
            @slot("type")
                {{session("messageType")}}
            @endslot
            @slot("message")
                {{session("message")}}
            @endslot
        @endcomponent
    @endif


    <form method="POST" action="{{ route('storeUser') }}" enctype="multipart/form-data">
        @csrf
        <h3 class="box-title m-t-40">Cadastro de Usuário</h3>
        <hr>
        <div class="row">
            <div class="col-md-6">
                <div class="row">
                    <div class="col-md-12 form-group">
                        <label for="user-name">Digite o nome:</label>
                        <input type="text" placeholder="Digite aqui" name="name" class="form-control"/>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12 form-group">
                        <label for="user-email">Digite o email:</label>
                        <input type="email" placeholder="Digite aqui" name="email" class="form-control"/>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12 form-group">
                        <label for="user-password">Digite uma senha:</label>
                        <input type="password" placeholder="Digite aqui" name="password" class="form-control"/>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12 form-group">
                        <label for="user-permission">Permissão:</label>
                        <select name="user_permission" id="user-permission" class="form-control" >
                            <option value="-1" selected disabled="disabled">Selecione uma Permissão</option>
                            @foreach ($permissions as $permission)
                            <option value="{{$permission->id}}">{{$permission->name}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <label class="col-sm-12">Foto</label>
                            <div class="col-sm-12">
                                <div class="fileinput fileinput-new input-group" data-provides="fileinput">
                                    <div class="form-control" data-trigger="fileinput"> 
                                        <i class="glyphicon glyphicon-file fileinput-exists"></i> 
                                        <span class="fileinput-filename"></span>
                                    </div> 
                                    <span class="input-group-addon btn btn-default btn-file"> 
                                        <span class="fileinput-new">Selecionar um arquivo</span> 
                                        <span class="fileinput-exists">Modificar</span>
                                        <input type="file" name="file"> 
                                    </span> 
                                    <a href="#" class="input-group-addon btn btn-default fileinput-exists" data-dismiss="fileinput">Remover</a> 
                                </div>
                            </div>
                        </div> 
                    </div>
                </div>
                <div class="form-actions">
                    <button type="submit" class="btn btn-info waves-effect waves-light">Salvar</button>
                    <button type="cancel" class="btn btn-inverse waves-effect waves-light">Cancelar</button>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection

@push("scripts")
<script src="//cdnjs.cloudflare.com/ajax/libs/jasny-bootstrap/4.0.0/js/jasny-bootstrap.min.js"></script>
@endpush