@extends('layouts.app')
@section("pageTitle", "Edição de Usuário")

@push("styles")



@endpush

@section("content")
<div class="row">
    <div class="col-lg-12">
        <div class="white-box">
                <p class="text-muted m-b-30 font-13"></p>
        
                @if ($errors->any())
                    @component('components.alert')
                        @slot("type")
                            danger
                        @endslot
                        @slot("message")
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        @endslot
                    @endcomponent
                @endif
                @if(session("hasMessage") != "")
                    @component('components.alert')
                        @slot("type")
                            {{session("messageType")}}
                        @endslot
                        @slot("message")
                            {{session("message")}}
                        @endslot
                    @endcomponent
                @endif

                <form method="POST" action="{{ route('updateUser', $user->id) }}"  enctype="multipart/form-data" class="form-horizontal">
                    @csrf
                    @method('PUT')
                
                        <h3 class="box-title m-t-40">Edição de Usuário</h3>
                        <hr>
                        <div class="row">
                            <div class="col-md-8">
                                <div class="row">
                                    <div class="col-md-12 form-group">
                                        <label for="txtName">Nome</label>
                                        <input type="text" name="txtName" id="txtName" class="form-control" placeholder="Nome..." value="<?= $user->name?>"/> 
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12 form-group">
                                        <label for="user-email">E-mail:</label>
                                        <input type="email" placeholder="Digite aqui" name="email" name="user-email" class="form-control" value="<?= $user->email?>"/>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12 form-group">
                                        <label for="newPassword">Digite uma senha:</label>
                                        <input type="password" placeholder="Digite aqui" name="newPassword" id="newPassword" class="form-control" />
                                        <input type="hidden" value="{{$user->password}}" name="lastPassword"  />
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="row">
                                    <div class="col-md-6">
                                        <img class="img-responsive" src="<?= url("{$user->photo}")?>" />
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12 m-t-2">
                                        <div class="form-group">
                                            <div class="fileinput fileinput-new input-group" data-provides="fileinput">
                                                <div class="form-control" data-trigger="fileinput"> 
                                                    <i class="glyphicon glyphicon-file fileinput-exists"></i> 
                                                    <span class="fileinput-filename"></span>
                                                </div> 
                                                <span class="input-group-addon btn btn-default btn-file"> 
                                                    <span class="fileinput-new">Selecionar um arquivo</span> 
                                                    <span class="fileinput-exists">Modificar</span>
                                                    <input type="file" name="file"> 
                                                </span> 
                                                <a href="#" class="input-group-addon btn btn-default fileinput-exists" data-dismiss="fileinput">Remover</a> 
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12 form-group">
                                <label for="user-permission">Permissão:</label>
                                <select name="user_permission" id="user-permission" class="form-control" >
                                    <option value="-1" selected disabled="disabled">Selecione uma Permissão</option>
                                    @foreach ($permissions as $permission)
                                    <option value="{{$permission->id}}" {{ $user->permission_id == $permission->id ? "selected" : ""}}>{{$permission->name}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="form-actions">
                            <button type="submit" class="btn btn-info waves-effect waves-light">Salvar</button>
                            <button type="cancel" class="btn btn-inverse waves-effect waves-light">Cancelar</button>
                        </div>
                </form>    
        </div>
    </div>
</div>
@endsection

@push("scripts")

@endpush