@extends('layouts.app')
@section("pageTitle", "Listagem de Usuários")

@push("styles")
   
@endpush

@section("content")
<div class="white-box">

    <h3 class="box-title m-b-0">Usuários</h3>
    @if(session("hasMessage") != "")
        @component('components.alert')
                @slot("type")
                    {{session("messageType")}}
                @endslot
                @slot("message")
                    {{session("message")}}
                @endslot
        @endcomponent
    @endif
    <div class="button-box pull-right">
        <a class="btn btn-info waves-effect waves-light" href="{{route("createUser")}}">
            <span class="btn-label"><i class="fa fa-plus"></i></span>
            <span>Adicionar</span> 
        </a>
    </div>
    <table class="table color-table info-table">
        <thead>
            <tr>
                <th>Nome de Usuário</th>
                <th>E-mail</th>
                <th>Data</th>
                <th>Permissão</th>
                <th>Ações</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($users as $user)
            <tr>
                <td><img src="{{asset("/asset/images/profile-photo.png")}}" alt="" class="table__profile-photo img-fluid"><span class="table__company">{{$user->name}}</span></td>
                <td><span class="table__email">{{$user->email}}</span></td>
                <td><span class="table__date">{{$user->created_at->format('d/m/Y')}}</span></td>
                <td><span class="status--finished">{{$user->permission->name}}</span></td>
                <td>
                    <a href="{{route('showUser',$user->id)}}" data-toggle="tooltip" data-original-title="Visualizar" class="btn btn-success btn-circle"><i class="fa fa-pencil"> </i></a>
                    <a href="{{route('deleteUser',$user->id)}}" data-toggle="tooltip" data-original-title="Deletar" class="btn btn-danger btn-circle"><i class="fa fa-close"> </i></a>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>

</div>

@endsection

@push("scripts")

@endpush