<?php

use App\Http\Controllers\CelebrationPriceItemController;
use App\Http\Controllers\GoogleSheetsIntegrationController;
use App\Http\Controllers\VpdPriceItemController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::get("celebrations-prices", [GoogleSheetsIntegrationController::class,"index"]);

Route::controller(CelebrationPriceItemController::class)->group(function () {
    Route::post('celeration-prices-item/list-data',"listData");
    Route::post('celeration-prices-item/store', "store");
    Route::put('celeration-prices-item/update-batch', "updateBatch");
    Route::put('celeration-prices-item/{celebrationPriceItem}', "update");
    Route::get('celeration-prices-item/{celebrationPriceItem}', "show");
});

Route::controller(VpdPriceItemController::class)->group(function () {
    Route::post('vpd-prices-item/list-data',"listData");
    Route::post('vpd-prices-item/import-celebration-prices',"importCelebrationPrices");
    Route::post('vpd-prices-item/import-updated-prices',"importUpdatedPrices");
    Route::post('vpd-prices-item/store', "store");
    Route::put('vpd-prices-item/update-batch', "updateBatch");
    Route::put('vpd-prices-item/{celebrationPriceItem}', "update");
    Route::get('vpd-prices-item/{celebrationPriceItem}', "show");
});


//Route::post("celebrations-prices-list-data", [CelebrationPriceItemController::class,"listData"]);
