<?php

use App\Http\Controllers\AuthController;
use App\Http\Controllers\CelebrationPriceItemController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\LogUpdateController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\VpdPriceItemController;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Artisan;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get("/pnig", function () {
    return ["pong" => true];
});

//Auth
Route::controller(AuthController::class)->group(function () {
    Route::get('/', "index")->middleware("auth");
    Route::get("/login", "index")->name("login");
    Route::post("/login", "authenticate")->name("doLogin");
    Route::get("/logout", "logout");
});


Route::get('/storare-link', function () {
    Artisan::call('storage:link');
});

Route::get('/cache-clear', function () {
    Artisan::call('cache:clear');
});


Route::middleware(["auth", "can:admin,can:master"])->prefix('admin')->group(function () {
    Route::get('dashboard', [DashboardController::class, "index"])->name("dashboard");
    Route::get('users', [UserController::class, "index"])->name("users");

    Route::controller(UserController::class)->group(function () {
        Route::get('usuarios', "index")->name("listUser");
        Route::get('usuarios/novo', "create")->name("createUser");
        Route::post('usuarios/novo', "store")->name("storeUser");
        Route::get('usuarios/{user}', "edit")->name("showUser");
        Route::put('usuarios/{user}', "update")->name("updateUser");
        Route::get('usuarios/delete/{user}', "destroy")->name("deleteUser");
    });

    Route::controller(CelebrationPriceItemController::class)->group(function () {
        Route::get('celebrations-prices-table', "index")->name("listCelebrationPriceItem");
        Route::get('celebrations-prices-table/new', "create")->name("createCelebrationPriceItem");
        Route::post('celebrations-prices-table/new', "store")->name("storeCelebrationPriceItem");
        Route::get('celebrations-prices-table/{celebrationPriceItem}', "edit")->name("showCelebrationPriceItem");
        Route::put('celebrations-prices-table/{celebrationPriceItem}', "update")->name("updateCelebrationPriceItem");
        Route::get('celebrations-prices-table/delete/{celebrationPriceItem}', "destroy")->name("deleteCelebrationPriceItem");
    });

    Route::controller(VpdPriceItemController::class)->group(function () {
        Route::get('vpd-prices-table', "index")->name("listVpdPriceItem");
        Route::post('vpd-prices-table/update-rates', "updateRates")->name("VpdUpdateRatesItems");
        Route::get('vpd-prices-table/new', "create")->name("createVpdPriceItem");
        Route::post('vpd-prices-table/new', "store")->name("storeVpdPriceItem");
        Route::get('vpd-prices-table/{vpdPriceItem}', "edit")->name("showVpdPriceItem");
        Route::put('vpd-prices-table/{vpdPriceItem}', "update")->name("updateVpdPriceItem");
        Route::get('vpd-prices-table/delete/{vpdPriceItem}', "destroy")->name("deleteVpdPriceItem");
    });

    Route::controller(LogUpdateController::class)->group(function () {
        Route::get('log-updates-table', "index")->name("listLogUpdates");
    });

    

    Route::get("image/{folder}/{itemId}/{filename}", [ImageController::class, "show"])->name("image.showImage");
    Route::get("image/{folder}/{itemId}/{filename}/hasImage", [ImageController::class, "hasImage"])->name("image.hasImage");
});

Route::middleware(["auth", "can:hotelManager"])->prefix('celebration')->group(function () {
    Route::get('dashboard', [DashboardCompanyController::class, "index"])->name("dashboardCompany");
});
