
<?php $__env->startSection("pageTitle", "Log Updates"); ?>

<?php $__env->startPush("styles"); ?>


<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap.min.css">
<?php $__env->stopPush(); ?>

<?php $__env->startSection("content"); ?>
<div class="white-box">

    <h3 class="box-title m-b-0">Log Updates</h3>
    <?php if(session("hasMessage") != ""): ?>
        <?php $__env->startComponent('components.alert'); ?>
                <?php $__env->slot("type"); ?>
                    <?php echo e(session("messageType")); ?>

                <?php $__env->endSlot(); ?>
                <?php $__env->slot("message"); ?>
                    <?php echo e(session("message")); ?>

                <?php $__env->endSlot(); ?>
        <?php echo $__env->renderComponent(); ?>
    <?php endif; ?>
    <table class="table color-table info-table display" id="customTable" style="width:100%">
        <thead>
            <tr>
                <th>#</th>
                <th>Date</th>
                <th>Quantity Items Updated</th>
                <th>User</th>
              
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>    
            <tr>
                <td><?php echo e($log->id); ?></td>
                <td><?php echo e(\Carbon\Carbon::parse($log->created_at)->format("Y-m-d H:i:s")); ?></td>
                <td><?php echo e($log->quantity_items_updated); ?></td>

                <td><?php echo e($log->user->name); ?></td>
                
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

   
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush("scripts"); ?>
<script src="//cdn.jsdelivr.net/npm/sweetalert2@10"></script>
<script type="text/javascript">
    let urlCelebrationPrices = '<?= url("api/celeration-prices-item") ?>';
</script>

<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\vpdtravel-celebration-suites\resources\views/log-updates/list.blade.php ENDPATH**/ ?>