
<?php $__env->startSection("pageTitle", "Listagem de Usuários"); ?>

<?php $__env->startPush("styles"); ?>
   
<?php $__env->stopPush(); ?>

<?php $__env->startSection("content"); ?>
<div class="white-box">

    <h3 class="box-title m-b-0">Usuários</h3>
    <?php if(session("hasMessage") != ""): ?>
        <?php $__env->startComponent('components.alert'); ?>
                <?php $__env->slot("type"); ?>
                    <?php echo e(session("messageType")); ?>

                <?php $__env->endSlot(); ?>
                <?php $__env->slot("message"); ?>
                    <?php echo e(session("message")); ?>

                <?php $__env->endSlot(); ?>
        <?php echo $__env->renderComponent(); ?>
    <?php endif; ?>
    <div class="button-box pull-right">
        <a class="btn btn-info waves-effect waves-light" href="<?php echo e(route("createUser")); ?>">
            <span class="btn-label"><i class="fa fa-plus"></i></span>
            <span>Adicionar</span> 
        </a>
    </div>
    <table class="table color-table info-table">
        <thead>
            <tr>
                <th>Nome de Usuário</th>
                <th>E-mail</th>
                <th>Data</th>
                <th>Permissão</th>
                <th>Ações</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><img src="<?php echo e(asset("/asset/images/profile-photo.png")); ?>" alt="" class="table__profile-photo img-fluid"><span class="table__company"><?php echo e($user->name); ?></span></td>
                <td><span class="table__email"><?php echo e($user->email); ?></span></td>
                <td><span class="table__date"><?php echo e($user->created_at->format('d/m/Y')); ?></span></td>
                <td><span class="status--finished"><?php echo e($user->permission->name); ?></span></td>
                <td>
                    <a href="<?php echo e(route('showUser',$user->id)); ?>" data-toggle="tooltip" data-original-title="Visualizar" class="btn btn-success btn-circle"><i class="fa fa-pencil"> </i></a>
                    <a href="<?php echo e(route('deleteUser',$user->id)); ?>" data-toggle="tooltip" data-original-title="Deletar" class="btn btn-danger btn-circle"><i class="fa fa-close"> </i></a>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush("scripts"); ?>

<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\vpdtravel-celebration-suites\resources\views/users/list.blade.php ENDPATH**/ ?>