
<?php $__env->startSection("pageTitle", "VPD Price List"); ?>

<?php $__env->startPush("styles"); ?>


<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap.min.css">
<?php $__env->stopPush(); ?>

<?php $__env->startSection("content"); ?>
<div class="white-box">

    <h3 class="box-title m-b-0">VPD Price List</h3>
    <?php if(session("hasMessage") != ""): ?>
        <?php $__env->startComponent('components.alert'); ?>
                <?php $__env->slot("type"); ?>
                    <?php echo e(session("messageType")); ?>

                <?php $__env->endSlot(); ?>
                <?php $__env->slot("message"); ?>
                    <?php echo e(session("message")); ?>

                <?php $__env->endSlot(); ?>
        <?php echo $__env->renderComponent(); ?>
    <?php endif; ?>
    <div class="row p-t-2 p-b-2">
        <div class="col-md-12 text-right">
            <button class="btn btn-primary btn-import-celebration-prices">Import Celebration Prices</button>
            <button class="btn btn-primary btn-import-updated-prices">Import Updated Prices</button>
            <button class="btn btn-success btn-export">Go Live Prices</button>
        </div>
    </div>

    <div class="row p-t-2 p-b-2">
        <div class="pull-right col-md-8 text-right">
            <form action="<?php echo e(route('VpdUpdateRatesItems')); ?>" class="form-horizontal" method="POST">
                <?php echo csrf_field(); ?>
                <div class="form-group form-inline">
                    <input type="text" id="priceInCash" name="priceInCash" class="form-control" placeholder="Price in cash">
                    <input type="text" id="priceInSixTimes" name="priceInSixTimes" class="form-control" placeholder="Price in six times">
                    <input type="text" id="priceInTenTimes" name="priceInTenTimes" class="form-control" placeholder="Price in cash">
                    <button type="submit" class="btn btn-primary btn-save-rates m-l-10">Save Rates</button>
                </div>
            </form>
        </div>
    </div>
    <table class="table color-table info-table display" id="customTable" style="width:100%">
        <thead>
            <tr>
                <th>#</th>
                <th>Checkin</th>
                <th>Sku</th>
                <th>Bedroom</th>
                <th>Min. Nights</th>
                <th>Cost</th>
                <th>Price</th>
                <th>In Cash</th>
                <th>Six Times</th>
                <th>Ten Times</th>
                <th>Bathrooms</th>
                <th>Status</th>
            </tr>
        </thead>
        
    </table>

    <div class="row">
        
    </div>
</div>
<!-- Modal -->
<div class="modal fade" id="modelEdit" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Editar Valores</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
            </div>
            <div class="modal-body">
                <form id="frmEdit">
                    <div class="row">
                        <div class="form-group">
                            <label for="checkin">Checkin</label>
                            <input type="text" class="form-control" id="checkin" placeholder="Checkin" readonly>
                        </div>
                    </div>
                    <div class="row">
                        <div class="form-group">
                            <label for="bedroom">Bedroom</label>
                            <input type="text" class="form-control" id="bedroom" placeholder="Bedroom" readonly>
                        </div>
                    </div>
                    <div class="row">
                        <div class="form-group">
                            <label for="min_nights">Min. Nights</label>
                            <input type="text" class="form-control" id="minNights" placeholder="Min. Nights" readonly>
                        </div>
                    </div>
                    <div class="row">
                        <div class="form-group">
                            <label for="cost">Cost</label>
                            <input type="text" class="form-control" id="cost" placeholder="Cost">
                        </div>
                    </div>
                    <div class="row">
                        <div class="form-group">
                            <label for="status">Status</label>
                            <select name="status" id="status" class="form-control">
                                <option value="0">Disabled</option>
                                <option value="1">Active</option>
                            </select>
                        </div>
                    </div>
                    <input type="hidden" id="id" name="id">
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" id="btnSave">Save</button>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush("scripts"); ?>
<script src="//cdn.jsdelivr.net/npm/sweetalert2@10"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap.min.js"></script>
<script type="text/javascript">
        let urlVpdPrices = '<?= url("api/vpd-prices-item") ?>';

</script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.4/moment-with-locales.min.js" integrity="sha512-42PE0rd+wZ2hNXftlM78BSehIGzezNeQuzihiBCvUEB3CVxHvsShF86wBWwQORNxNINlBPuq7rG4WWhNiTVHFg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script type="text/javascript" src="<?php echo e(asset("/assets/js/views/vpd-prices.js")); ?>"></script>

<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\vpdtravel-celebration-suites\resources\views/vpd-prices/list.blade.php ENDPATH**/ ?>