
<?php $__env->startSection("pageTitle", "Criação de Usuários"); ?>

<?php $__env->startPush("styles"); ?>
<link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/jasny-bootstrap/4.0.0/css/jasny-bootstrap.min.css">
<?php $__env->stopPush(); ?>

<?php $__env->startSection("content"); ?>

<div class="white-box">
    <p class="text-muted m-b-30 font-13"></p>

    <?php if($errors->any()): ?>
        <?php $__env->startComponent('components.alert'); ?>
            <?php $__env->slot("type"); ?>
                danger
            <?php $__env->endSlot(); ?>
            <?php $__env->slot("message"); ?>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php $__env->endSlot(); ?>
        <?php echo $__env->renderComponent(); ?>
    <?php endif; ?>
    <?php if(session("hasMessage") != ""): ?>
        <?php $__env->startComponent('components.alert'); ?>
            <?php $__env->slot("type"); ?>
                <?php echo e(session("messageType")); ?>

            <?php $__env->endSlot(); ?>
            <?php $__env->slot("message"); ?>
                <?php echo e(session("message")); ?>

            <?php $__env->endSlot(); ?>
        <?php echo $__env->renderComponent(); ?>
    <?php endif; ?>


    <form method="POST" action="<?php echo e(route('storeUser')); ?>" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <h3 class="box-title m-t-40">Cadastro de Usuário</h3>
        <hr>
        <div class="row">
            <div class="col-md-6">
                <div class="row">
                    <div class="col-md-12 form-group">
                        <label for="user-name">Digite o nome:</label>
                        <input type="text" placeholder="Digite aqui" name="name" class="form-control"/>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12 form-group">
                        <label for="user-email">Digite o email:</label>
                        <input type="email" placeholder="Digite aqui" name="email" class="form-control"/>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12 form-group">
                        <label for="user-password">Digite uma senha:</label>
                        <input type="password" placeholder="Digite aqui" name="password" class="form-control"/>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12 form-group">
                        <label for="user-permission">Permissão:</label>
                        <select name="user_permission" id="user-permission" class="form-control" >
                            <option value="-1" selected disabled="disabled">Selecione uma Permissão</option>
                            <?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($permission->id); ?>"><?php echo e($permission->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <label class="col-sm-12">Foto</label>
                            <div class="col-sm-12">
                                <div class="fileinput fileinput-new input-group" data-provides="fileinput">
                                    <div class="form-control" data-trigger="fileinput"> 
                                        <i class="glyphicon glyphicon-file fileinput-exists"></i> 
                                        <span class="fileinput-filename"></span>
                                    </div> 
                                    <span class="input-group-addon btn btn-default btn-file"> 
                                        <span class="fileinput-new">Selecionar um arquivo</span> 
                                        <span class="fileinput-exists">Modificar</span>
                                        <input type="file" name="file"> 
                                    </span> 
                                    <a href="#" class="input-group-addon btn btn-default fileinput-exists" data-dismiss="fileinput">Remover</a> 
                                </div>
                            </div>
                        </div> 
                    </div>
                </div>
                <div class="form-actions">
                    <button type="submit" class="btn btn-info waves-effect waves-light">Salvar</button>
                    <button type="cancel" class="btn btn-inverse waves-effect waves-light">Cancelar</button>
                </div>
            </div>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush("scripts"); ?>
<script src="//cdnjs.cloudflare.com/ajax/libs/jasny-bootstrap/4.0.0/js/jasny-bootstrap.min.js"></script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\vpdtravel-celebration-suites\resources\views/users/create.blade.php ENDPATH**/ ?>